﻿
//
// Merge all the selected objects into the first selected object
//

// find the mesh child
function findFirstChildMeshElement(parent) {
    // find the mesh child
    for (var i = 0; i < parent.childCount; i++) {

        // get child and its materials
        var child = parent.getChild(i);
        if (child.typeId == "Microsoft.VisualStudio.3D.Mesh") {
            return child;
        }
    }
    return null;
}

function UndoableItem(meshArray) {
    this._elements = meshArray;
    this._geom = new Array();

    this._prevMaterials = meshArray[0].behavior.materials.clone();

    for (var i = 0; i < meshArray.length; i++) {
        var geomCopy = meshArray[i].getTrait("Geometry").value.clone();
        this._geom.push(geomCopy);    
    }

    this.getName = function () {
        var IDS_MreUndoMergeObjects = 150;
        return services.strings.getStringFromId(IDS_MreUndoMergeObjects);
    }

    this.onDo = function () {

        this._deletedElementParent = new Array();
        this._deletedElement = new Array();

        var mergeTo = this._elements[0].behavior;
        for (var i = 1; i < this._elements.length; i++) {

            var meshElemToMergeFrom = this._elements[i];
            var mergeFromMesh = meshElemToMergeFrom.behavior;
            mergeTo.mergeFrom(mergeFromMesh);

            var owningSceneNode = meshElemToMergeFrom.parent;

            // delete the merged mesh, always place the parent of deleted element into
            // deleted parent array so that we can reparent on restore/undo
            this._deletedElement.push(meshElemToMergeFrom);
            this._deletedElementParent.push(meshElemToMergeFrom.parent);

            document.deleteSceneElement(meshElemToMergeFrom);

            // should we delete the parent?
            if (owningSceneNode.childCount == 0) {

                // again, always place the parent of deleted element into
                // deleted parent array so that we can reparent on restore/undo
                this._deletedElement.push(owningSceneNode);
                this._deletedElementParent.push(owningSceneNode.parent);

                document.deleteSceneElement(owningSceneNode);
            }
        }

        mergeTo.recomputeCachedGeometry();
    }

    this.onUndo = function () {

        for (var i = 0; i < this._elements.length; i++) {

            // restore the geometry
            this._elements[i].getTrait("Geometry").value.copyFrom(this._geom[i]);
            this._elements[i].behavior.recomputeCachedGeometry();
        }

        for (var i = 0; i < this._deletedElement.length; i++) {
            var elem = this._deletedElement[i];
            var parent = this._deletedElementParent[i];
            elem.parent = parent;
            document.elements.append(elem);
        }

        var materials = this._elements[0].behavior.materials;
        materials.removeAll();
        for (var i = 0; i < this._prevMaterials.elementCount; i++) {
            materials.append(this._prevMaterials.getElement(i));
        }
    }
}

var selectedElementCount = services.selection.count;
var meshElements = new Array();

// loop over selected
for (var i = 0; i < selectedElementCount; i++) {
    var selectedElement = services.selection.getElement(i);

    // add mesh elements to collection
    var meshElement = findFirstChildMeshElement(selectedElement);
    if (meshElement != null) {
        meshElements.push(meshElement);
    }
}

if (meshElements.length > 1) {
    var undoableItem = new UndoableItem(meshElements);
    undoableItem.onDo();
    services.undoService.addUndoableItem(undoableItem);
}
// SIG // Begin signature block
// SIG // MIIkAwYJKoZIhvcNAQcCoIIj9DCCI/ACAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // cMRbXRGmc2yh0YXON5Bg2LXmpBSMZxC2hdtmg8Q+dbKg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFcgwghXEAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggbYwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEILcOPSHBC1LSAJJEqXM8ExpipiLo4cJjPJNmviQg
// SIG // i68mMEoGCisGAQQBgjcCAQwxPDA6oCCAHgBNAGUAcgBn
// SIG // AGUATwBiAGoAZQBjAHQAcwAuAGoAc6EWgBRodHRwOi8v
// SIG // bWljcm9zb2Z0LmNvbTANBgkqhkiG9w0BAQEFAASCAQCr
// SIG // Ykxccp7xe/IE3ZOMbhQ6j6xQU30xwTjYkLLEr2TjW8CG
// SIG // qUYXerPdy/iKYkX9DcJLMKqzUqZONge6nC6DJFDevU8k
// SIG // F2HL/rhOgND3ZAjH5BXBEw4LXD9oYsxFSFlMKSST8/OX
// SIG // z0PwLRZH8iwYZhi6ZtZP+prs57IjLeMGklFwCgFVjSJA
// SIG // 78apklk1BjIIYK+Qv9K6AQhn1BLfy/QH8wK8Cnsxx1G6
// SIG // z8q41YsNwMKWMofHfeM8XGgfY+cnl7UKyyh2rqfnKY29
// SIG // b+u5mka+pXj4ny3388KDgE/YSGmkjQ7Eh8/TMI3sUcW4
// SIG // x2Xm8VpqYBlEakk04oQvFJsB34GwwCTwoYITSjCCE0YG
// SIG // CisGAQQBgjcDAwExghM2MIITMgYJKoZIhvcNAQcCoIIT
// SIG // IzCCEx8CAQMxDzANBglghkgBZQMEAgEFADCCAT0GCyqG
// SIG // SIb3DQEJEAEEoIIBLASCASgwggEkAgEBBgorBgEEAYRZ
// SIG // CgMBMDEwDQYJYIZIAWUDBAIBBQAEIP1iRw+PPPMO24e3
// SIG // OPCUxWs20/xz15AQeQQHy6Qy7lhVAgZYr4s244QYEzIw
// SIG // MTcwMzA0MjMyNDA2LjU0M1owBwIBAYACAfSggbmkgbYw
// SIG // gbMxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1P
// SIG // UFIxJzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVTTjo3MjhE
// SIG // LUM0NUYtRjlFQjElMCMGA1UEAxMcTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgU2VydmljZaCCDs0wggZxMIIEWaADAgEC
// SIG // AgphCYEqAAAAAAACMA0GCSqGSIb3DQEBCwUAMIGIMQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylNaWNyb3Nv
// SIG // ZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAx
// SIG // MDAeFw0xMDA3MDEyMTM2NTVaFw0yNTA3MDEyMTQ2NTVa
// SIG // MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqR0NvHcR
// SIG // ijog7PwTl/X6f2mUa3RUENWlCgCChfvtfGhLLF/Fw+Vh
// SIG // wna3PmYrW/AVUycEMR9BGxqVHc4JE458YTBZsTBED/Fg
// SIG // iIRUQwzXTbg4CLNC3ZOs1nMwVyaCo0UN0Or1R4HNvyRg
// SIG // MlhgRvJYR4YyhB50YWeRX4FUsc+TTJLBxKZd0WETbijG
// SIG // GvmGgLvfYfxGwScdJGcSchohiq9LZIlQYrFd/XcfPfBX
// SIG // day9ikJNQFHRD5wGPmd/9WbAA5ZEfu/QS/1u5ZrKsajy
// SIG // eioKMfDaTgaRtogINeh4HLDpmc085y9Euqf03GS9pAHB
// SIG // IAmTeM38vMDJRF1eFpwBBU8iTQIDAQABo4IB5jCCAeIw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwHQYDVR0OBBYEFNVjOlyK
// SIG // MZDzQ3t8RhvFM2hahW1VMBkGCSsGAQQBgjcUAgQMHgoA
// SIG // UwB1AGIAQwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8E
// SIG // BTADAQH/MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQ
// SIG // W9fOmhjEMFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9j
// SIG // cmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3Rz
// SIG // L01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggr
// SIG // BgEFBQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93
// SIG // d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9v
// SIG // Q2VyQXV0XzIwMTAtMDYtMjMuY3J0MIGgBgNVHSABAf8E
// SIG // gZUwgZIwgY8GCSsGAQQBgjcuAzCBgTA9BggrBgEFBQcC
// SIG // ARYxaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL1BLSS9k
// SIG // b2NzL0NQUy9kZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0
// SIG // HjIgHQBMAGUAZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMA
// SIG // dABhAHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG9w0BAQsF
// SIG // AAOCAgEAB+aIUQ3ixuCYP4FxAz2do6Ehb7Prpsz1Mb7P
// SIG // BeKp/vpXbRkws8LFZslq3/Xn8Hi9x6ieJeP5vO1rVFcI
// SIG // K1GCRBL7uVOMzPRgEop2zEBAQZvcXBf/XPleFzWYJFZL
// SIG // dO9CEMivv3/Gf/I3fVo/HPKZeUqRUgCvOA8X9S95gWXZ
// SIG // qbVr5MfO9sp6AG9LMEQkIjzP7QOllo9ZKby2/QThcJ8y
// SIG // Sif9Va8v/rbljjO7Yl+a21dA6fHOmWaQjP9qYn/dxUoL
// SIG // kSbiOewZSnFjnXshbcOco6I8+n99lmqQeKZt0uGc+R38
// SIG // ONiU9MalCpaGpL2eGq4EQoO4tYCbIjggtSXlZOz39L9+
// SIG // Y1klD3ouOVd2onGqBooPiRa6YacRy5rYDkeagMXQzafQ
// SIG // 732D8OE7cQnfXXSYIghh2rBQHm+98eEA3+cxB6STOvdl
// SIG // R3jo+KhIq/fecn5ha293qYHLpwmsObvsxsvYgrRyzR30
// SIG // uIUBHoD7G4kqVDmyW9rIDVWZeodzOwjmmC3qjeAzLhIp
// SIG // 9cAvVCch98isTtoouLGp25ayp0Kiyc8ZQU3ghvkqmqMR
// SIG // ZjDTu3QyS99je/WZii8bxyGvWbWu3EQ8l1Bx16HSxVXj
// SIG // ad5XwdHeMMD9zOZN+w2/XU/pnR4ZOC+8z1gFLu8NoFA1
// SIG // 2u8JJxzVs341Hgi62jbb01+P3nSISRIwggTaMIIDwqAD
// SIG // AgECAhMzAAAAsjUFaDciHA2nAAAAAACyMA0GCSqGSIb3
// SIG // DQEBCwUAMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNV
// SIG // BAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEw
// SIG // MB4XDTE2MDkwNzE3NTY1N1oXDTE4MDkwNzE3NTY1N1ow
// SIG // gbMxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1P
// SIG // UFIxJzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVTTjo3MjhE
// SIG // LUM0NUYtRjlFQjElMCMGA1UEAxMcTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgU2VydmljZTCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBAJhKAbvRWPV/dJFC6aEuU13y
// SIG // LCBvEi6b09eVldydb4l8DmtwKU2wLg81VvaPAkv4fFVt
// SIG // UM0/x6p48hAHqAdrA7v8K/CqJZ3d/PFjcCRlb4T6S0Re
// SIG // znIofcKzH8VvhmqZh666/swFmL5vvhWCR2W3L3XKvNoQ
// SIG // eps7Mk/aHUiSDiLnsbFCbVnCYp4sKgrwNTcgAgns4RTj
// SIG // tRfjgH5U7l1RDpPZmkozya8mDev2ayOVLz9dEiE3SiTP
// SIG // jr0Pm1M/7unujHB72jv1armZPLfbAXwSyz9VzvSv1ga5
// SIG // OjzffCfUcpTNr0oJNsYi7F1zvTrigBod9b13cI1jcHvA
// SIG // wPbunjRph7cCAwEAAaOCARswggEXMB0GA1UdDgQWBBQz
// SIG // ZL5naxzc+WNEBkjkxUPJkPaClTAfBgNVHSMEGDAWgBTV
// SIG // YzpcijGQ80N7fEYbxTNoWoVtVTBWBgNVHR8ETzBNMEug
// SIG // SaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NybC9wcm9kdWN0cy9NaWNUaW1TdGFQQ0FfMjAxMC0w
// SIG // Ny0wMS5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUF
// SIG // BzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NlcnRzL01pY1RpbVN0YVBDQV8yMDEwLTA3LTAxLmNy
// SIG // dDAMBgNVHRMBAf8EAjAAMBMGA1UdJQQMMAoGCCsGAQUF
// SIG // BwMIMA0GCSqGSIb3DQEBCwUAA4IBAQBB4LKgoMr0KG/M
// SIG // jd3+270gVYlsICl2dj/UJ8lee4P7wcJHNo32eiFMRBs6
// SIG // cWOrIya/RK6iGe8n1liGunpw+i+0S+RxSDpX0rX/oxAb
// SIG // mgnDXx4J6DDNketUXMELWf706lIvqHo1a2C2gzgJppp2
// SIG // 25az1zWHqGQ6XAbPTBMNxiIYtwBjjLh1sUXhqUda2//8
// SIG // uxodVDnbFV/mV+Q0nngv/bTcIN/SExCjzj1x2eGwXmVZ
// SIG // e45s7pWzmd/wqBxhD0xPV6rWxDH2fA1i62xrAKEKhNJ8
// SIG // cSknIqTYEw/Aesid3To56t4nBtwEYY48aoSa3062mu2w
// SIG // TOH6UY2AQgWmJvaDbwHmoYIDdjCCAl4CAQEwgeOhgbmk
// SIG // gbYwgbMxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsT
// SIG // BE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVTTjo3
// SIG // MjhELUM0NUYtRjlFQjElMCMGA1UEAxMcTWljcm9zb2Z0
// SIG // IFRpbWUtU3RhbXAgU2VydmljZaIlCgEBMAkGBSsOAwIa
// SIG // BQADFQC9/8WVY5DxE5xg1hnAr+m4nh4gHaCBwjCBv6SB
// SIG // vDCBuTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxME
// SIG // TU9QUjEnMCUGA1UECxMebkNpcGhlciBOVFMgRVNOOjRE
// SIG // RTktMEM1RS0zRTA5MSswKQYDVQQDEyJNaWNyb3NvZnQg
// SIG // VGltZSBTb3VyY2UgTWFzdGVyIENsb2NrMA0GCSqGSIb3
// SIG // DQEBBQUAAgUA3GVwYTAiGA8yMDE3MDMwNDE2NTcwNVoY
// SIG // DzIwMTcwMzA1MTY1NzA1WjB0MDoGCisGAQQBhFkKBAEx
// SIG // LDAqMAoCBQDcZXBhAgEAMAcCAQACAhLNMAcCAQACAhoP
// SIG // MAoCBQDcZsHhAgEAMDYGCisGAQQBhFkKBAIxKDAmMAwG
// SIG // CisGAQQBhFkKAwGgCjAIAgEAAgMW42ChCjAIAgEAAgMH
// SIG // oSAwDQYJKoZIhvcNAQEFBQADggEBAIQGcMNW9UgiAn+C
// SIG // zxiXPAYpaQ9EGG3lRUQomEstggCn1jKQaOoEHBkoM/w3
// SIG // Gm9RND4/rDYQ4dBuNe/AJX/BQEPKHSVAuR+hvioFSeA1
// SIG // UoMr5gg7QkPPFWFa1pBcIQBP3lpVkkxRJFIzRGb/Af32
// SIG // oPUrqJvDPhkaDQI9jihSXnmgfHt9sfbtkVoy7HYqDfK3
// SIG // PWpEtng6d6iZJU0yifoPI4yMBSS69WMX2JSNxaPecSqV
// SIG // jpnUBtM9/UxzoCIJB48U0psiSqSoZwix5lWbhjWAgLEB
// SIG // OnIyf+mAtfGfy2D7CrzerZxyb3/icLEjuRuAzS96bXSD
// SIG // EPiPaKINIDxnbIj6zdcxggL1MIIC8QIBATCBkzB8MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3Nv
// SIG // ZnQgVGltZS1TdGFtcCBQQ0EgMjAxMAITMwAAALI1BWg3
// SIG // IhwNpwAAAAAAsjANBglghkgBZQMEAgEFAKCCATIwGgYJ
// SIG // KoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEEMC8GCSqGSIb3
// SIG // DQEJBDEiBCBFPbekqMtHzlpuQPYW9WN3WbjuXxHiB9ea
// SIG // cG7yTVYpyTCB4gYLKoZIhvcNAQkQAgwxgdIwgc8wgcww
// SIG // gbEEFL3/xZVjkPETnGDWGcCv6bieHiAdMIGYMIGApH4w
// SIG // fDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMAAACy
// SIG // NQVoNyIcDacAAAAAALIwFgQUcCgFQjkGq31fIS+5tzyi
// SIG // Z9qmNeYwDQYJKoZIhvcNAQELBQAEggEAPqlr9oTQzkUQ
// SIG // qqJP4xVefL2UzgTmHQrO5oFhAZNmRNxIpKzL+o5zVWGB
// SIG // g0+m61Q1YgNHQIJxpxMR40Iz5kn5KS4555+bYuoaRnRS
// SIG // cbVifliz4wSICBBWD4EzgNR+FYZJDpAc4IdF3HJ/dEis
// SIG // czi/aHEkysvYNQt5337srVJY4W8B0mrXMSYOQwJHIL5/
// SIG // bjHGgpa5Wj2KdSV/ARIapvB3YulfMdb8rmCRHMB5PNQc
// SIG // Ox4iNm6QIgS6xWSMeKlSFdrDDWiv+avb0bFMxhrcSEKJ
// SIG // uqVBkktUSmh1+e6etktAbDXzxe0w3cFXOx/IB4UsZXdz
// SIG // JWs0WrSjx5wW/Bo4zlYC1w==
// SIG // End signature block
